// Name: onsclick
// Description: on single click script
// Version: r1y2005
// Creator: Maximilian Scherr
// Date: 24 April 2005

uses
  Basic, UOSL;

var
  ClickedType: Integer;
  Clicker, Clicked: TObjectReference;

begin
  Clicker := GetObjectReference(OTPLAYER, StrToCard(Parameter1));
  ClickedType := StrToInt(Parameter2);
  Clicked := GetObjectReference(ClickedType, StrToCard(Parameter3));
  if IsCriminal(Clicked) then
    begin
      SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, GetName(Clicked), 255, 0, 0);
        if not IsUnhidden(Clicked) then
          SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, '[hidden]', 255, 0, 0);
        
        if not IsAlive(Clicked) then
          SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, '[dead]', 255, 0, 0);
        
        if IsPrivileged(Clicked) then
          SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, '[priviliged]', 255, 0, 0);
      
    end

  else
    begin
      SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, GetName(Clicked), 0, 0, 255);
      if not IsUnhidden(Clicked) then
        SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, '[hidden]', 0, 0, 255);
      
      if not IsAlive(Clicked) then
        SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, '[dead]', 0, 0, 255);
      
      if IsPrivileged(Clicked) then
        SendText(TTTEXTABOVEPRIVATE, Clicked, Clicker, '[priviliged]', 0, 0, 255);
      
    end;
    
end.